-- Cavebot by otclient@otclient.ovh
-- visit http://bot.otclient.ovh/

function getNearTiles(pos)
	if (type(pos) ~= "table") then
		pos = player:getPosition();
	end
	
	local tiles = {};
	for x = -1, 1 do
		for y = -1, 1 do
			local tile = g_map.getTile({x = pos.x+x, y = pos.y+y, z = pos.z});
			if (tile ~= nil) then
				table.insert(tiles, tile);
			end
		end
	end
	
	table.removevalue(tiles, g_map.getTile(pos));
	return tiles;
end

function distanceFromPlayer(p2)
	return getDistanceBetween(player:getPosition(), p2);
end

if (table.recursivecopy == nil) then
	table.recursivecopy = function(t)
		local res = {};
		for k,v in pairs(t) do
			if type(v) == "table" then
				res[k] = table.recursivecopy(v);
			else
				res[k] = v;
			end
		end
		return res;
	end
end

local main = function()
	local cavebotTab = "Cave"
	local targetingTab = "Target"

	setDefaultTab(cavebotTab)
	CaveBot = {} -- global namespace
	CaveBot.Extensions = {}
	importStyle("/cavebot/cavebot.otui")
	importStyle("/cavebot/config.otui")
	importStyle("/cavebot/editor.otui")
	importStyle("/cavebot/supply.otui")

	dofile("/cavebot/tyrConfig.lua")

	dofile("/cavebot/actions.lua")
	dofile("/cavebot/config.lua")
	dofile("/cavebot/editor.lua")
	dofile("/cavebot/example_functions.lua")
	dofile("/cavebot/recorder.lua")
	dofile("/cavebot/walking.lua")
	-- dofile("/cavebot/minimap.lua")
	-- in this section you can add extensions, check extension_template.lua
	--dofile("/cavebot/extension_template.lua")
	dofile("/cavebot/sell_all.lua")
	dofile("/cavebot/depositor.lua")
	dofile("/cavebot/supply.lua")
	dofile("/cavebot/d_withdraw.lua")
	dofile("/cavebot/travel.lua")
	dofile("/cavebot/doors.lua")
	dofile("/cavebot/pos_check.lua")
	dofile("/cavebot/withdraw.lua")
	dofile("/cavebot/inbox_withdraw.lua")
	dofile("/cavebot/lure.lua")
	dofile("/cavebot/bank.lua")
	dofile("/cavebot/clear_tile.lua")
	dofile("/cavebot/tasker.lua")
	dofile("/cavebot/imbuing.lua")
	dofile("/cavebot/stand_lure.lua")

	-- main cavebot file, must be last
	dofile("/cavebot/cavebot.lua")

	setDefaultTab(targetingTab)
	TargetBot = {} -- global namespace
	importStyle("/targetbot/looting.otui")
	importStyle("/targetbot/target.otui")
	importStyle("/targetbot/creature_editor.otui")
	dofile("/targetbot/creature.lua")
	dofile("/targetbot/creature_attack.lua")
	dofile("/targetbot/creature_editor.lua")
	dofile("/targetbot/creature_priority.lua")
	dofile("/targetbot/looting.lua")
	dofile("/targetbot/walking.lua")
	-- main targetbot file, must be last
	dofile("/targetbot/target.lua")


	CaveBotList = function()
		return CaveBot.actionList
	end

	CaveBot.getCurrentProfile = function()
		return tyrBot.storage._configs.cavebot_configs.selected
	end

	CaveBot.setCurrentProfile = function(name)
		if not g_resources.fileExists(configDir .."/cavebot_configs/"..name..".cfg") then
			return warn("there is no cavebot profile with that name!")
		end
		CaveBot.setOff()
		tyrBot.storage._configs.cavebot_configs.selected = name
		CaveBot.setOn()
	end
end


cavebot_main = function()
	if (tyrBot ~= nil and tyrBot.storage ~= nil) then
		main();
		return;
	end
	schedule(1, cavebot_main);
end

cavebot_main();